<?php
/* PHP interface description for TET
 * Copyright (c) PDFlib GmbH 2009-2020
 *
 * Note that this is only a syntax summary.
 * For complete information please refer to the API reference
 * which is available in the distribution.
 */

class TETException {
/**
 * Get the number of the last thrown exception or the reason for a failed function call.
 */
function get_errnum() {}

/**
 * Get the text of the last thrown exception or the reason for a failed function call.
 */
function get_errmsg() {}

/**
 * Get the name of the API function which threw the last exception or failed.
 */
function get_apiname() {}
};


class TET {


/**
 * Release a document handle and all internal resources related to that document
 *
 * @param int $doc
 */
function close_document($doc) {}


/**
 * Release a page handle and all related resources.
 *
 * @param int $page
 */
function close_page($page) {}


/**
 * Convert a string in an arbitrary encoding to a Unicode string in various formats.
 *
 * @param string $inputformat
 * @param string $inputstring
 * @param string $optlist
 * @return  The converted Unicode string.
 */
function convert_to_unicode($inputformat, $inputstring, $optlist) {}


/**
 * Create a named virtual read-only file from data provided in memory.
 *
 * @param string $filename
 * @param string $data
 * @param string $optlist
 */
function create_pvf($filename, $data, $optlist) {}


/**
 * Delete a named virtual file and free its data structures.
 *
 * @param string $filename
 * @return  -1 if the virtual file exists but is locked, and 1 otherwise.
 */
function delete_pvf($filename) {}


/**
 * Get the name of the API function which caused an exception or failed.
 *
 * @return  Name of an API function.
 */
function get_apiname() {}


/**
 * Get detailed information for the next character in the most recent text fragment.
 *
 * @param int $page
 * @return  Bindig-specific error or success code.
 */
function get_char_info($page) {}


/**
 * Get detailed information for a color id which has been retrieved with TET_get_char_info(). The results are reported in public fields.
 *
 * @param int $doc
 * @param int $colorid
 * @param string $optlist
 * @return  Details about the requested color space and color.
 */
function get_color_info($doc, $colorid, $optlist) {}


/**
 * Get the text of the last thrown exception or the reason for a failed function call.
 *
 * @return  Text containing the description of the most recent error condition.
 */
function get_errmsg() {}


/**
 * Get the number of the last thrown exception or the reason for a failed function call.
 *
 * @return  Error number of the most recent error condition.
 */
function get_errnum() {}


/**
 * Write image data to memory.
 *
 * @param int $doc
 * @param int $imageid
 * @param string $optlist
 * @return  Data representing the image according to the specified options.
 */
function get_image_data($doc, $imageid, $optlist) {}


/**
 * Retrieve information about the next image on the page (but not the actual pixel data).
 *
 * @param int $page
 * @return  Details about the next image on the page.
 */
function get_image_info($page) {}


/**
 * Get the next text fragment from a page's content.
 *
 * @param int $page
 * @return  A string containing the next text fragment on the page.
 */
function get_text($page) {}


/**
 * Query properties of a virtual file or the PDFlib Virtual Filesystem (PVF).
 *
 * @param string $filename
 * @param string $keyword
 * @return  The value of some file parameter as requested by keyword.
 */
function info_pvf($filename, $keyword) {}


/**
 * Open a disk-based or virtual PDF document for content extraction.
 *
 * @param string $filename
 * @param string $optlist
 * @return  -1 on error, or a document handle otherwise.
 */
function open_document($filename, $optlist) {}


/**
 * Open a page for text extraction.
 *
 * @param int $doc
 * @param int $pagenumber
 * @param string $optlist
 * @return  A handle for the page, or -1 in case of an error.
 */
function open_page($doc, $pagenumber, $optlist) {}


/**
 * Get the value of a pCOS path with type number or boolean.
 *
 * @param int $doc
 * @param string $path
 * @return  The numerical value of the object identified by the pCOS path.
 */
function pcos_get_number($doc, $path) {}


/**
 * Get the value of a pCOS path with type name, number, string, or boolean.
 *
 * @param int $doc
 * @param string $path
 * @return  A string with the value of the object identified by the pCOS path.
 */
function pcos_get_string($doc, $path) {}


/**
 * Get the contents of a pCOS path with type stream, fstream, or string.
 *
 * @param int $doc
 * @param string $optlist
 * @param string $path
 * @return  The unencrypted data contained in the stream or string.
 */
function pcos_get_stream($doc, $optlist, $path) {}


/**
 * Set one or more global options for TET.
 *
 * @param string $optlist
 */
function set_option($optlist) {}


/**
 * Write image data to disk.
 *
 * @param int $doc
 * @param int $imageid
 * @param string $optlist
 * @return  -1 on error, or the image format otherwise (see IF_TIFF etc.)
 */
function write_image_file($doc, $imageid, $optlist) {}


/**
 * Process a page and create TETML output.
 *
 * @param int $doc
 * @param int $pageno
 * @param string $optlist
 * @return  Always 1. PDF problems are reported in a TETML Exception element.
 */
function process_page($doc, $pageno, $optlist) {}


/**
 * Retrieve TETML data from memory.
 *
 * @param int $doc
 * @param string $optlist
 * @return  A byte array containing the next chunk of TETML data.
 */
function get_tetml($doc, $optlist) {}

};
?>
